<?php
session_start();  // Start the session

$is_invalid = false;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $mysqli = require __DIR__ . '/database.php';

    // Use a prepared statement to avoid SQL injection
    $sql = "SELECT * FROM user WHERE email = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("s", $_POST["email"]);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user) {
        // Verify the password
        if (password_verify($_POST["password"], $user["password_hash"])) {
            // Store the user's information in the session
            $_SESSION["user_id"] = $user["id"];
            $_SESSION["username"] = $user["name"];
            $_SESSION["email"] = $user["email"]; 

            // Redirect to the logged-in page
            header("Location: Logged.php");
            exit;
        }
    }

    // If login fails, set the $is_invalid flag to true
    $is_invalid = true;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="style.css">
  <title>Log in - ArloMusic</title>
  <style>
    /* Basic Reset */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Arial', sans-serif;
      background-color: #f7f7f76e;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .signup-container {
      background-color: #0000003a;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
      width: 100%;
      max-width: 400px;
      display: block;
      margin-top: 20px;
    margin-left: auto;
    margin-right: auto;
    position: relative;
    min-width: 400px;
    }

    h2 {
        font-size: 16px;
        font-family: "Montserrat", sans-serif;
    font-weight: 100;
    font-style: normal;
      text-align: center;
      color: #ffffff;
      margin-bottom: 20px;
      text-decoration: none;
    color: white;
    font-family: "Nunito", sans-serif;
    font-optical-sizing: auto;
    font-weight: 300;
    }

    .form-group {
      margin-bottom: 15px;
    }

    label {
      display: block;
      font-weight: normal;
      margin-bottom: 5px;
        color: #ffffff;
        text-decoration: none;
    color: white;
    font-family: "Nunito", sans-serif;
    font-optical-sizing: auto;
    font-weight: 300;
    }

    input[type="text"],
    input[type="email"],
    input[type="password"] {
      width: 100%;
      padding: 10px;
      font-size: 16px;
      border: 1px solid #cccccc49;
      border-radius: 4px;
      transition: all 0.3s ease;
    }

    input[type="text"]:focus,
    input[type="email"]:focus,
    input[type="password"]:focus {
      border-color: #007bff;
      outline: none;
      box-shadow: 0 0 8px rgba(0, 123, 255, 0.3);
      background-color: #ffffff;
    }

    .form-group.checkbox {
      display: inline flex;
      align-items: center;
      margin-top: 0px;
    }

    .form-group.checkbox label {
      font-weight: normal;
      margin-left: 8px;
      margin-top: 5px;
      text-decoration: none;
    color: white;
    font-family: "Nunito", sans-serif;
    font-optical-sizing: auto;
    font-weight: 300;
    }

    .submit-btn {
      width: 100%;
      padding: 12px;
      background-color: #007bff;
      border: none;
      color: white;
      font-size: 18px;
      cursor: pointer;
      border-radius: 4px;
      transition: background-color 0.3s ease;
      text-decoration: none;
    color: white;
    font-family: "Nunito", sans-serif;
    font-optical-sizing: auto;
    font-weight: 300;
    }

    .submit-btn:hover {
      background-color: #0056b3;
    }

    .login-link {
      margin-top: 15px;
      text-align: center;
    }

    .login-link a {
      color: #007bff;
      text-decoration: none;
      text-decoration: none;
    font-family: "Nunito", sans-serif;
    font-optical-sizing: auto;
    font-weight: 300;
    
    }

    .login-link a:hover {
      text-decoration: underline;
      
    }
    /* Mobile menu styling */
@media (max-width: 768px) {
    html, body {
    overflow-x: hidden;
    overflow-y: hidden;
}
       /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
}

.hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
}

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
    }

.hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .signup-container {
      background-color: #0000003a;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
      width: 100%;
      max-width: 300px;
      display: block;
      margin-top: 20px;
    margin-left: auto;
    margin-right: auto;
    position: relative;
    min-width: 100px;
    }
  }
  </style>
</head>
<body>

  <section class="header" id="NavSection">
    <nav class="navbar">
        <a href="index.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
        <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
            </div>
        <div class="nav-links" id="navLinks">
        <ul>
        <li class="navButton"><a href="index.php">Home</a></li>
                <li class="navButton"><a href="TopPage.php">Top</a></li>
                <li class="navButton"><a href="">Artists</a></li>
                <li class="navButton"><a class href="AccountCreate.php">Sign up</a></li>
        </ul>
    </div>
    </nav>
    
  <div class="signup-container">
  
    <h2>Log in To Your ArloMusic Account</h2>
    <?php if ($is_invalid): ?>
      <h2>Invalid log in credentials</h2>
    <?php endif; ?>
    <form method="POST">

      <!-- Email Field -->
      <div class="form-group">
        <label for="email">Email Address</label>
        <input type="email" id="email" name="email" value="<?= htmlspecialchars($_POST["email"] ?? "") ?>" placeholder="Enter your email" required>

      </div>

      <!-- Password Field -->
      <div class="form-group">
        <label for="password">Password</label>
        <input type="password" id="password" name="password" placeholder="Enter your password" required>
      </div>

      <!-- Submit Button -->
      <button type="submit" class="submit-btn">Log in</button>
    </form>

    <div class="login-link">
      <p>Dont have a account? <a href="AccountCreate.php">Sign up</a></p>
    </div>
  </div>

</section>
<script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>
